## フォントファイルの作成方法

lib-9341\Kanji\Fontsの中に含まれている、日本語フォントファイルは、[PyFontConverter](https://github.com/HisayukiNomura/PyFontConverter) を使って、TrueTypeフォントを変換して作成しています。

### ダウンロードと変換
Githubから、　font.py　をダウンロードし、コマンドラインなどからpythonを使って実行します。一部のフォントファイル、たとえば ipag_24x24_all.incなどには、実行されたコマンドがコメントとして書かれています。 ```// font.py -s 24 -cs ALL ipag.ttf``` 
これらを参考に、ヘッダファイルを作成してください。

コマンドの詳細な使用方法は、githubページを参照してください。

良く使用するオプションは

- -s フォントサイズ   変換後のフォントのドット数
- -cs コードセット　　ALL…JIS第１、２を含むすべて、LEVEL1…JIS第１水準、記号やかななど

です。その他、細かいオプションがあります。 --help をつけるとヘルプが表示されます。


### 変換の「コツ」

- プロポーショナルフォントは正しく変換できません。一部のフォントでは、日本語（全角文字）は固定ピッチ、半角文字はプロポーショナルになっているものもあります。すべてが固定ピッチになっている必要があります。
- 変換後、文字が中央に入らず、バランスが悪かったり文字の一部が欠けてしまうことがあります。この場合、-xoと-yoを使用して、文字の一を調整してください。値は負の値も指定できます。
- マイコンのメモリにとって漢字フォントは非常に大きなフットプリントとなってしまいます。とくに大きなフォントを使用する場合などは、文字セットを小さくする（教育漢字のみ）、使用している文字だけを含める(-cs CUSTOM  -cf 使用している文字一覧)などを使用してください。
- 変換後のファイル名は *.h でも構いませんが、多くの高機能なエディタではC言語としての構文解析が行われてしまい、動作が遅くなる場合があります。  ファイル名を *.txt や *.inc などに変更すると、より快適に使用できます。


