
#include <KanjiDisplay_SSD1306.h>


void cKanjiDisplay_SSD1306::vDrawBitmap(int16_t x, int16_t y, const uint8_t bitmap[], int16_t w,int16_t h, uint16_t color)
{
    drawBitmap( x,y,bitmap,w,h,color);
}

/**************************************************************************/
/*!
    @brief  Print one byte/character of data, used to support print()
    @param  c  The 8-bit ascii character to write
*/
/**************************************************************************/
size_t cKanjiDisplay_SSD1306::write(uint8_t c) {

    if ( GetFontKind() == cKanjiDisplay::FontKind::Default ){
       return Adafruit_SSD1306::write(c);
    }
    const KanjiData * Kanji = KanjiWrite( cursor_x,cursor_y, c , textcolor);
    if( Kanji != NULL ){
      cursor_x += Kanji->width ;
    }
    return 1 ;
}


